/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: DnsFal_Public.h 59944 2016-03-16 11:44:03Z trieu                      $

   Description:
    ............................................................................

    Includes following functions:

   Changes:

     Version     Date        Author
     X.X.X.X   DD.MM.JJJJ  Mustermann
     Description................................................................
     ---------------------------------------------------------------------------
     1.0       12.01.15    TD
        Change DNS_FAL_LED_TYPE_NS to DNS_FAL_LED_TYPE_MNS
     1.0       25.03.10    MK
     -  New register flags DNS_FAL_EVENT_IO_CHANGED_IND
     -  all references to unused packet und command for download req. removed.
     1.0       03.11.09    MK
     -  New register flags DNS_FAL_EVENT_IO_UPDATE_IND/
        DNS_FAL_EVENT_LED_STATE_IND
     1.0       09.05.07    MK
*******************************************************************************/
#ifndef __DNS_FAL_PUBLIC_H
#define __DNS_FAL_PUBLIC_H

/** Process queue name */
#define DNS_FAL_QUEUE_NAME        "QUE_DNS_FAL"

/******************************************************************************/
/*                            DNS FAL Commands                                */
/******************************************************************************/
#define DNS_FAL_CMD_REG_APP_REQ          /*Register Application Req */0x00002D00
#define DNS_FAL_CMD_REG_APP_CNF          /*Register Application Cnf */0x00002D01
#define DNS_FAL_CMD_INIT_STACK_REQ       /*Init Stack Request       */0x00002D02
#define DNS_FAL_CMD_INIT_STACK_CNF       /*Init Stack Confirm       */0x00002D03
#define DNS_FAL_CMD_GET_STATUS_REQ       /*Get Status Request       */0x00002D04
#define DNS_FAL_CMD_GET_STATUS_CNF       /*Get Status Confirm       */0x00002D05
#define DNS_FAL_CMD_SET_MODE_REQ         /*Set Mode Request         */0x00002D06
#define DNS_FAL_CMD_SET_MODE_CNF         /*Set Mode Confirm         */0x00002D07
#define DNS_FAL_CMD_CLR_CONFIG_REQ       /*Clear Config Request     */0x00002D08
#define DNS_FAL_CMD_CLR_CONFIG_CNF       /*Clear Config Confirm     */0x00002D09
#define DNS_FAL_CMD_UPDATE_IO_REQ        /*Update IO Request        */0x00002D0C
#define DNS_FAL_CMD_UPDATE_IO_CNF        /*Update IO Confirm        */0x00002D0D
#define DNS_FAL_CMD_SET_INPUT_REQ        /*Set Input Request        */0x00002D0E
#define DNS_FAL_CMD_SET_INPUT_CNF        /*Set Input Confirm        */0x00002D0F
#define DNS_FAL_CMD_GET_OUTPUT_REQ       /*Get Output Request       */0x00002D10
#define DNS_FAL_CMD_GET_OUTPUT_CNF       /*Get Output Confirmation  */0x00002D11
#define DNS_FAL_CMD_GET_SET_ATT_IND      /*Get Set Attr Indication  */0x00002D16
#define DNS_FAL_CMD_GET_SET_ATT_INDRET   /*Get Set Attr Ind. Return */0x00002D17
#define DNS_FAL_CMD_GET_SET_ATT_RES      /*Get Set Attr Response    */0x00002D14
#define DNS_FAL_CMD_GET_SET_ATT_RESRET   /*Get Set Attr Res. Return */0x00002D15
#define DNS_FAL_CMD_BUS_EVENT_IND        /*Bus Event Indication     */0x00002D18
#define DNS_FAL_CMD_BUS_EVENT_RES        /*Bus Event Response       */0x00002D19
#define DNS_FAL_CMD_UPDATE_IO_IND        /*Update IO indication     */0x00002D1A
#define DNS_FAL_CMD_UPDATE_IO_RES        /*Update IO response       */0x00002D1B
#define DNS_FAL_CMD_LED_STATE_IND        /*LED state indication     */0x00002D1C
#define DNS_FAL_CMD_LED_STATE_RES        /*LED state response       */0x00002D1D
#define DNS_FAL_CMD_REGISTER_CLASS_REQ   /*register class request   */0x00002D1E
#define DNS_FAL_CMD_REGISTER_CLASS_CNF   /*register class confirm   */0x00002D1F
#define DNS_FAL_CMD_UNREGISTER_CLASS_REQ /*unregister class request */0x00002D20
#define DNS_FAL_CMD_UNREGISTER_CLASS_CNF /*unregister class confirm */0x00002D21
#define DNS_FAL_CMD_REMOTE_SERVICE_IND   /*remote service indication*/0x00002D22
#define DNS_FAL_CMD_REMOTE_SERVICE_RES   /*remote service response  */0x00002D23
#define DNS_FAL_CMD_SERVICE_REQ          /*local service request    */0x00002D24
#define DNS_FAL_CMD_SERVICE_CNF          /*local service confirm    */0x00002D25
#define DNS_FAL_CMD_ADR_SW_ENABLE_IND    /*address switch enable req*/0x00002D26
#define DNS_FAL_CMD_ADR_SW_ENABLE_RES    /*address switch enable cnf*/0x00002D27


/******************************************************************************/
/*                         COMMON CIP CLASS ID                                */
/******************************************************************************/
#define DNS_CIP_CLASS_IDENTITY                                              0x01
#define DNS_CIP_CLASS_MESSAGE_ROUTER                                        0x02
#define DNS_CIP_CLASS_DEVICENET                                             0x03
#define DNS_CIP_CLASS_ASSEMBLY                                              0x04
#define DNS_CIP_CLASS_CONNECTION                                            0x05
#define DNS_CIP_CLASS_PARAMETER                                             0x0F
#define DNS_CIP_CLASS_ACKNOWLEDGE_HANDLER                                   0x2B

/******************************************************************************/
/*                     COMMON CIP DEVICENET CLASS ATTRIBUTE                   */
/******************************************************************************/
#define DNS_CIP_CLASS_DEVICENET_ALL_ATTRS               /*  NOT SUPPORTED */0x00
#define DNS_CIP_CLASS_DEVICENET_REVISION                                    0x01
#define DNS_CIP_CLASS_DEVICENET_MACID                                       0x01
#define DNS_CIP_CLASS_DEVICENET_BAUD                                        0x02
#define DNS_CIP_CLASS_DEVICENET_BOI            /* Bus Off Interrupt */      0x03
#define DNS_CIP_CLASS_DEVICENET_BUS_OFF_CNTR   /* Bus off counter */        0x04
#define DNS_CIP_CLASS_DEVICENET_ALLOC_INFO /* connection allocation info */ 0x05
#define DNS_CIP_CLASS_DEVICENET_MACSWCHANGED /* MAC ID Switch Changed */    0x06
#define DNS_CIP_CLASS_DEVICENET_BAUDSWCHANGED /* Baudrate Switch Changed */ 0x07
#define DNS_CIP_CLASS_DEVICENET_MACSWVALUE    /* MAC ID Switch Value */     0x08
#define DNS_CIP_CLASS_DEVICENET_BAUDSWVALUE   /* Baudrate Switch Value */  0x09
#define DNS_CIP_CLASS_DEVICENET_QUIX_CNXN               /*  QUICK_CONNECT */0x0A

/******************************************************************************/
/*                         COMMON CIP SERVICE CODE                            */
/******************************************************************************/
//#define served for future use                                           00 n/a
#define DNS_CIP_SRV_CODE_GET_ATTRIBUTES_ALL                                 0x01
#define DNS_CIP_SRV_CODE_SET_ATTRIBUTES_ALL                                 0x02
#define DNS_CIP_SRV_CODE_GET_ATTRIBUTE_LIST                                 0x03
#define DNS_CIP_SRV_CODE_SET_ATTRIBUTE_LIST                                 0x04
#define DNS_CIP_SRV_CODE_RESET                                              0x05
#define DNS_CIP_SRV_CODE_START                                              0x06
#define DNS_CIP_SRV_CODE_STOP                                               0x07
#define DNS_CIP_SRV_CODE_CREATE                                             0x08
#define DNS_CIP_SRV_CODE_DELETE                                             0x09
#define DNS_CIP_SRV_CODE_MULTIPLE_SERVICE_PACKET                            0x0A
//#define DNS_CIP_SRV_CODE_RESERVED FOR FUTURE USE                     0x0B-0x0C
#define DNS_CIP_SRV_CODE_APPLY_ATTRIBUTES                                   0x0D
#define DNS_CIP_SRV_CODE_GET_ATTRIBUTE_SINGLE                               0x0E
//#define DNS_CIP_SRV_CODE_SERVED FOR FUTURE USE                            0x0F
#define DNS_CIP_SRV_CODE_SET_ATTRIBUTE_SINGLE                               0x10
#define DNS_CIP_SRV_CODE_FIND_NEXT_OBJECT_INSTANCE                          0x11
//#define DNS_CIP_SRV_CODE_RESERVED FOR FUTURE USE                     0x12-0x13
#define DNS_CIP_SRV_CODE_ROR_RESPONSE /*USED BY DEVICENET ONLY*/            0x14
#define DNS_CIP_SRV_CODE_RESTORE                                            0x15
#define DNS_CIP_SRV_CODE_SAVE                                               0x16
#define DNS_CIP_SRV_CODE_NO_OPERATION                                       0x17
#define DNS_CIP_SRV_CODE_GET_MEMBER                                         0x18
#define DNS_CIP_SRV_CODE_SET_MEMBER                                         0x19
#define DNS_CIP_SRV_CODE_INSERT_MEMBER                                      0x1A
#define DNS_CIP_SRV_CODE_REMOVE_MEMBER                                      0x1B
#define DNS_CIP_SRV_CODE_GROUPSYNC                                          0x1C
//#define DNS_CIP_SRV_CODE_RESERVED FOR ADDITIONAL COMMON SERVICES     0x1D-0x31

/******************************************************************************/
/*                      COMMON CIP GENERAL ERROR CODE                         */
/******************************************************************************/
/* Service was successfully performed by the object specified.                */
#define DNS_CIP_GEN_E_SUCCESS                                               0x00

/* A connection related service failed along the connection path.             */
#define DNS_CIP_GEN_E_CONNECTION_FAILURE                                    0x01

/* Resources needed for the object to perform the service were unavailable    */
#define DNS_CIP_GEN_E_RESOURCE_UNAVAILABLE                                  0x02

/* See Status Code 0x20,  preferred value to use for this condition           */
#define DNS_CIP_GEN_E_INVALID_PARAMETER_VALUE                               0x03

/* The path segment identifier or the segment syntax was not understood by the*
   processing node. Path processing stops on a path segment error             */
#define DNS_CIP_GEN_E_PATH_SEGMENT_ERROR                                    0x04

/* The path is referencing an object class, instance or structure element that*
 * is not known or is not contained in the processing node. Path processing   *
 * shall stop when a path destination unknown error is encountered.           */
#define DNS_CIP_GEN_E_PATH_DESTINATION_UNKNOWN                              0x05

/* Only part of the expected data was transferred.                            */
#define DNS_CIP_GEN_E_PARTIAL_TRANSFER                                      0x06

/* The messaging connection was lost.                                         */
#define DNS_CIP_GEN_E_CONNECTION_LOST                                       0x07

/* The requested service was not implemented/defined for this Class/Instance  */
#define DNS_CIP_GEN_E_SERVICE_NOT_SUPPORTED                                 0x08

/* Invalid attribute data detected                                            */
#define DNS_CIP_GEN_E_INVALID_ATTRIBUTE_VALUE                               0x09

/* An attribute in the Get/Set_Attribute_List response has a non-zero status  */
#define DNS_CIP_GEN_E_ATTRIBUTE_LIST_ERROR                                  0x0A

/* The object is already in the mode/state being requested by the service     */
#define DNS_CIP_GEN_E_ALREADY_IN_REQUESTED_STATE                            0x0B

/* The object cannot perform the requested service in its current mode/state  */
#define DNS_CIP_GEN_E_OBJECT_STATE_CONFLICT                                 0x0C

/* The requested instance of object to be created already exists              */
#define DNS_CIP_GEN_E_OBJECT_ALREADY_EXISTS                                 0x0D

/* A request to modify a non-modifiable attribute was received                */
#define DNS_CIP_GEN_E_ATTRIBUTE_NOT_SETTABLE                                0x0E

/* A permission/privilege check failed                                        */
#define DNS_CIP_GEN_E_PRIVILEGE_VIOLATION                                   0x0F

/* The devices current mode/state prohibits the execution of the service     */
#define DNS_CIP_GEN_E_DEVICE_STATE_CONFLICT                                 0x10

/* The data to be transmitted in the response buffer is larger than the       *
 * allocated response buffer                                                  */
#define DNS_CIP_GEN_E_REPLY_DATA_TOO_LARGE                                  0x11

/* The service specified an operation that is going to fragment a primitive   *
 * data value, i.e. half a REAL data type.                                    */
#define DNS_CIP_GEN_E_FRAG_OF_A_PRIMITIVE_VALUE                             0x12

/* The service did not supply enough data to perform the specified operation. */
#define DNS_CIP_GEN_E_NOT_ENOUGH_DATA                                       0x13

/* The attribute specified in the request is not supported                    */
#define DNS_CIP_GEN_E_ATTRIBUTE_NOT_SUPPORTED                               0x14

/* The service supplied more data than was expected                           */
#define DNS_CIP_GEN_E_TOO_MUCH_DATA                                         0x15

/* The object specified does not exist in the device                          */
#define DNS_CIP_GEN_E_OBJECT_DOES_NOT_EXIST                                 0x16

/* The frag sequence for this service is not currently active for this data   */
#define DNS_CIP_GEN_E_SRV_FRAG_SEQ_NOT_IN_PROGRESS                          0x17

/* The attribute data of this object was not saved prior to the service       */
#define DNS_CIP_GEN_E_NO_STORED_ATTRIBUTE_DATA                              0x18

/*The attr data of this object was not saved due to failure during the attempt*/
#define DNS_CIP_GEN_E_STORE_OPERATION_FAILURE                               0x19

/*The service request packet was too large for transmission on a network in   *
 *the path to the destination. The routing dev was forced aborting the service*/
#define DNS_CIP_GEN_E_ROUTING_FAIL_REQ_PCK_TOO_BIG                          0x1A

/* The service response packet was too large for transmission on a network in *
 * the path from the destination. The routing device was forced aborting      *
 * the service.                                                               */
#define DNS_CIP_GEN_E_ROUTING_FAIL_RES_PCK_TOO_BIG                          0x1B

/* The service did not supply an attribute in a list of attributes that       *
 * was needed by the service to perform the requested behavior.               */
#define DNS_CIP_GEN_E_MISSING_ATTR_LIST_ENTRY_DATA                          0x1C

/* The service is returning the list of attributes supplied with status       *
   information for those attributes that were invalid                         */
#define DNS_CIP_GEN_E_INVALID_ATTR_VALUE_LIST                               0x1D

/* An embedded service resulted in an error                                   */
#define DNS_CIP_GEN_E_EMBEDDED_SERVICE_ERROR                                0x1E

/* A vendor specific error has been encountered. The Additional Code Field of *
 * the Error Response defines the particular error encountered. Use of this   *
 * General Error Code should only be performed when none of the Error Codes   *
 * presented in this table or within an Object Class definition accurately    *
 * reflect the error.                                                         */
#define DNS_CIP_GEN_E_VENDOR_SPECIFIC_ERROR                                 0x1F

/* A parameter associated with the request was invalid. This code is used when*
 * a parameter does not meet the requirements of this specification and/or the*
 * requirements defined in an Application Object Specification.               */
#define DNS_CIP_GEN_E_INVALID_PARAMETER                                     0x20

/* An attempt was made to write to a write-once medium (e.g. WORM drive, PROM)*
 * that has already been written, or to modify a value that cannot be changed *
 * once established.                                                          */
#define DNS_CIP_GEN_E_WRITE_ONCE_VALUE_OR_MEDIUM                            0x21

/* An invalid reply is received (e.g. reply service code does not match the   *
 * request service code, or reply message is shorter than the minimum expected*
 * reply size). This status code can serve for other causes of invalid replies*/
#define DNS_CIP_GEN_E_INVALID_REPLY_RECEIVED                                0x22

/* The message received is larger than the receiving buffer can handle.       *
 * The entire message was discarded                                           */
#define DNS_CIP_GEN_E_BUFFER_OVERFLOW                                       0x23

/* The format of the received message is not supported by the server          */
#define DNS_CIP_GEN_E_MESSAGE_FORMAT_ERROR                                  0x24

/* The Key Segment that was included as the first segment in the path does not*
 * match the destination module. The object specific status shall indicate    *
 * which part of the key check failed                                         */
#define DNS_CIP_GEN_E_KEY_FAILURE_IN_PATH                                   0x25

/* The size of the path which was sent with the Service Request is either not *
 * large enough to allow the Request to be routed to an object or too         *
 * much routing data was included.                                            */
#define DNS_CIP_GEN_E_PATH_SIZE_INVALID                                     0x26

/* An attempt was made to set an attr that is not able to be set at this time */
#define DNS_CIP_GEN_E_UNEXPECTED_ATTRIBUTE_IN_LIST                          0x27

/* The Member ID specified in the request does not exist in the specified     *
 * Class/Instance/Attribute                                                   */
#define DNS_CIP_GEN_E_INVALID_MEMBER_ID                                     0x28

/* A request to modify a non-modifiable member was received                   */
#define DNS_CIP_GEN_E_MEMBER_NOT_SETTABLE                                   0x29

/* This error code may only be reported by DeviceNet Group 2 Only servers with*
 * 4K or less code space and only in place of Service not supported,          *
 * Attribute not supported and Attribute not settable                         */
#define DNS_CIP_GEN_E_GROUP_2_ONLY_SERVER_GEN_FAIL                          0x2A

/* A CIP to Modbus translator received an unknown Modbus Exception Code       */
#define DNS_CIP_GEN_E_UNKNOWN_MODBUS_ERROR                                  0x2B

/* A request to read a non-readable attribute was received                    */
#define DNS_CIP_GEN_E_ATTRIBUTE_NOT_GETTABLE                                0x2C

//Reserved by CIP for future extensions            2D - CF //
/* This range of error codes is to be used to indicate Object Class specific  *
 * errors. Use of this range should only be performed when none of the Error  *
 * Codes presented in this table accurately reflect the error                 */
//Reserved for Object Class and service errors     D0 - FF

/******************************************************************************/
/*                             DNS Baudrates                                  */
/******************************************************************************/
#define   DNS_FAL_BAUDRATE_500kB                                               0
#define   DNS_FAL_BAUDRATE_250kB                                               1
#define   DNS_FAL_BAUDRATE_125kB                                               2

/******************************************************************************/
/*                              Operate Modes                                 */
/******************************************************************************/
#define DNS_FAL_MODE_OFFLINE                                                   0
#define DNS_FAL_MODE_STOP                                                      1
#define DNS_FAL_MODE_IDLE                                                      2
#define DNS_FAL_MODE_RUN                                                       3
#define DNS_FAL_MODE_BUS_OFF                                                   4

/******************************************************************************/
/*                         Get/Set Attribute Function                         */
/******************************************************************************/
#define DNS_FAL_GET_SET_ATT_WRITE                                              1
#define DNS_FAL_GET_SET_ATT_READ                                               2

/******************************************************************************/
/*                 Enable events within Application REG Req                   */
/******************************************************************************/
#define DNS_FAL_EVENT_IO_UPDATE_IND                                   0x00000001
#define DNS_FAL_EVENT_LED_STATE_IND                                   0x00000002
#define DNS_FAL_EVENT_IO_CHANGED_IND                                  0x00000004

#define DNS_FAL_EVENT_RESERVED                                        0xFFFFFFF8

/******************************************************************************/
/*                             Maximum I/O size                               */
/******************************************************************************/
#define DNS_FAL_MAX_IO_SIZE  256

/******************************************************************************/
/*              error return codes for Get/Set Attribute                      */
/******************************************************************************/
#define DNS_FAL_GET_SET_NO_ERROR                                            0x00
#define DNS_FAL_GET_SET_RES_NOT_AVAIL                                       0x02
#define DNS_FAL_GET_SET_SERV_NOT_AVAIL                                      0x08
#define DNS_FAL_GET_SET_ATTRIB_BAD_VALUE                                    0x09
#define DNS_FAL_GET_SET_ATTRIB_NO_SET                                       0x0E
#define DNS_FAL_GET_SET_ACCESS_DENIED                                       0x0F
#define DNS_FAL_GET_SET_STATE_CONFLICT                                      0x10
#define DNS_FAL_GET_SET_NOT_ENOUGH_DATA                                     0x13
#define DNS_FAL_GET_SET_ATTRIB_NOT_SUP                                      0x14
#define DNS_FAL_GET_SET_TOO_MUCH_DATA                                       0x15
#define DNS_FAL_GET_SET_VENDOR_SPEC_CODE                                    0x1F

/******************************************************************************/
/*                           DNS APPS defines                                 */
/******************************************************************************/
#define DNS_UNREGISTER_FORCE                                          0x00000001

/******************************************************************************/
/*                   Data status of produced/consumed data                    */
/******************************************************************************/
#define DNS_FAL_DS_ZERO            0x00000000/* Data are in safe state zero   */
#define DNS_FAL_DS_RECV_RUN        0x00000001/* Data are valid                */
#define DNS_FAL_DS_RECV_IDLE       0x00000002/* Data are in receive idle mode */
#define DNS_FAL_DS_RECV_IDLE_ZERO  0x00000003/* Data are in receive idle zero */
#define DNS_FAL_DS_HOLD_LAST_STATE 0x00000004
                                    /* Data are in safe state hold last state */
#define DNS_FAL_DS_USER_STATE      0x00000005
                                       /* Data are in safe state user defined */

/******************************************************************************/
/*        Enable flags in with command DNS_FAL_CMD_INIT_STACK_REQ             */
/******************************************************************************/
#define MSK_DNS_ENABLE_VENDORID                                       0x00000001
#define MSK_DNS_ENABLE_PRODUCTTYPE                                    0x00000002
#define MSK_DNS_ENABLE_PRODUCTCODE                                    0x00000004
#define MSK_DNS_ENABLE_MAJORMINORREV                                  0x00000008
#define MSK_DNS_ENABLE_SERIALNR                                       0x00000010
#define MSK_DNS_ENABLE_PRODUCTNAME                                    0x00000020
#define MSK_DNS_ENABLE_RESERVED                                       0xFFFFFFC0

/******************************************************************************/
/*      Configuration flags with command DNS_FAL_CMD_INIT_STACK_REQ           */
/******************************************************************************/
//#define MSK_DNS_CFG_FLAG_IGNORE_ADDR_SWITCH                           0x00000001
#define MSK_DNS_CFG_FLAG_CONTINUE_ON_BUSOFF                           0x00000002
#define MSK_DNS_CFG_FLAG_CONTINUE_ON_LOSS_NP                          0x00000004
#define MSK_DNS_CFG_FLAG_RECVIDLE_CLEAR_DATA                          0x00000008
#define MSK_DNS_CFG_FLAG_RECVIDLE_USER_DATA                           0x00000010
#define MSK_DNS_CFG_FLAG_24VDCINVERT                                  0x00000020
#define MSK_DNS_CFG_FLAG_ENABLE_SET_PRODCONS_SIZE_REMOTE              0x00000040
#define MSK_DNS_CFG_FLAG_ENABLE_SET_MACID_REMOTE                      0x00000080
#define MSK_DNS_CFG_FLAG_ENABLE_SET_BAUDRATE_REMOTE                   0x00000100
#define MSK_DNS_CFG_FLAG_ENABLE_DATA_STATUS                           0x00000200
#define MSK_DNS_CFG_FLAG_DISABLE_GET_SET_ATT_IND                      0x00000400

#define MSK_DNS_CFG_FLAG_RESERVED                                     0xFFFFF800


/******************************************************************************/
/*      System flags with command DNS_FAL_CMD_INIT_STACK_REQ                  */
/******************************************************************************/
#define MSK_DNS_SYS_FLG_MANUAL_START                                  0x00000001
#define MSK_DNS_SYS_FLG_ADR_SW_ENABLE                                 0x00000010
#define MSK_DNS_SYS_FLG_BAUD_SW_ENABLE                                0x00000020

#define MSK_DNS_SYS_FLG_RESERVED                                      0xFFFFFFCE



/******************************************************************************/
/*           Status flags with command DNS_FAL_CMD_GET_STATUS_REQ             */
/******************************************************************************/
#define MSK_DNS_STA_FLAG_BUS_PRM_VALID                                0x00000001
#define MSK_DNS_STA_FLAG_BUS_START                                    0x00000002
#define MSK_DNS_STA_FLAG_24V_NETWORK_POWER                            0x00000004
#define MSK_DNS_STA_FLAG_NETWORK_STATE_ONLINE                         0x00000008
#define MSK_DNS_STA_FLAG_RX_IDLE                                      0x00000010
#define MSK_DNS_STA_FLAG_ERR_DUP_MAC_ID                               0x00010000
#define MSK_DNS_STA_FLAG_ERR_BUS_OFF                                  0x00020000
#define MSK_DNS_STA_FLAG_ERR_MAJOR_UNRECOVERABLE                      0x00040000
#define MSK_DNS_STA_FLAG_RESERVED                                     0xFFF8FFE0

/******************************************************************************/
/*               LED States command DNS_FAL_CMD_LED_STATUS_IND                */
/******************************************************************************/
#define DNS_FAL_LED_TYPE_MNS                                                   1

#define DNS_FAL_LED_COLOR_OFF                                                  1
#define DNS_FAL_LED_COLOR_GREEN                                                2
#define DNS_FAL_LED_COLOR_RED                                                  3

#define DNS_FAL_LED_MODE_STATIC                                                1
#define DNS_FAL_LED_MODE_FLASH                                                 2


/******************************************************************************/
/*                            PACKET DEFINITION                               */
/******************************************************************************/
/*                                  pragma pack                               */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__DNS_FAL_PUBLIC)
#endif

/******************************************************************************/
/*                               Shared I/O memory                            */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_SHARED_IO_MEMORY_Ttag {
  TLR_UINT32  ulDataSta;                                /* See DNS_FAL_DS_ .. */
  TLR_UINT32  ulDataLen;                             /* Data length in abData */
  TLR_UINT8   abData[DNS_FAL_MAX_IO_SIZE];           /* Data load             */
} DNS_FAL_IO_MEM_T;

/******************************************************************************/
/*                       DNS_FAL_CMD_REG_APP_REQ Structure                    */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_REG_APP_REQ_Ttag {
  TLR_UINT32  ulMode;                          /* Values of DNS_FAL_EVENT_ .. */
} DNS_FAL_REG_APP_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_REG_APP_REQ_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_REG_APP_REQ_T tData;
} DNS_FAL_PACKET_REG_APP_REQ_T;

/*******************************************************************************
 *                       DNS_FAL_CMD_REG_APP_CNF Structure
 *
 * Registering the application queue handle must be done first before
 * proceeding with the stack initialization. This queue handle will be used
 * by the stack to notify the user application of GET/SET attribute requests
 * as well as BUS OFF and other events
*******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_REG_APP_CNF_Ttag {
  TLR_PACKET_HEADER_T tHead;
} DNS_FAL_PACKET_REG_APP_CNF_T;

/*******************************************************************************
 *                        DNS_FAL_CMD_INIT_STACK_REQ Structure
 *
 * The packet DNS_FAL_CMD_INIT_STACK_REQ can be used to configure the
 * DeviceNet-Slave Stack. The DeviceNet Slave Stack checks the parameter
 * which are sent with this packet. If all parameters are valid the DeviceNet
 * Slave Stack will directly take over the configuration.*
 ******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_INIT_STACK_REQ_Ttag {
  TLR_UINT32 ulSystemFlags;                 /* Values of MSK_DNS_SYS_FLG_ ..  */
  TLR_UINT32 ulWdgTime;                     /* Watchdog Time                  */
  TLR_UINT32 ulNodeId;                      /* 0 .. 63                        */
  TLR_UINT32 ulBaudrate;                    /* Values of DNS_FAL_BAUDRATE_ .. */
  TLR_UINT32 ulProducedSize;                /* 0.. 255                        */
  TLR_UINT32 ulConsumedSize;                /* 0.. 255                        */
  TLR_UINT32 ulConfigFlags;                 /* MSK_DNS_CFG_FLAG_ ..           */
  TLR_UINT32 ulEnableFlags;                 /* MSK_DNS_ENABLE_ ..             */
  TLR_UINT16 usVendorId;                    /* ODVA Vendor Identification     */
  TLR_UINT16 usProductType;                 /* Device Type                    */
  TLR_UINT16 usProductCode;                 /* Product Code                   */
  TLR_UINT8  bMinorRev;                     /* Minor Revision                 */
  TLR_UINT8  bMajorRev;                     /* Major Revision                 */
  TLR_UINT32 ulSerialNumber;                /* Serial number                  */
  TLR_UINT8  abReserved[3];                 /* Do not use                     */
  TLR_UINT8  bProductNameLen;               /* Name length in abProductName   */
  TLR_UINT8  abProductName[32];             /* Product Name                   */
} DNS_FAL_INIT_STACK_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_INIT_STACK_REQ_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_INIT_STACK_REQ_T tData;
} DNS_FAL_PACKET_INIT_STACK_REQ_T;

/******************************************************************************/
/*                   DNS_FAL_CMD_INIT_STACK_CNF Structure                     */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_INIT_STACK_CNF_Ttag {
  TLR_HANDLE hPdOutTrpBuf;                  /* Handle of Input Tripple Buffer */
  TLR_HANDLE hPdInTrpBuf;                   /* Handle of Output Tripple Buffer*/
} DNS_FAL_INIT_STACK_CNF_T;

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_INIT_STACK_CNF_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_INIT_STACK_CNF_T tData;
} DNS_FAL_PACKET_INIT_STACK_CNF_T;

/*******************************************************************************
 *                   DNS_FAL_CMD_GET_STATUS_REQ Structure
 * The DNS-Task can provide status information referring to its current
 * operational state by using the DNS_FAL_CMD_GET_STATUS_REQ/CNF command.
 * The answer provided in the confirmation packet contains exactly the
 * extended status block informing about CAN transmissions and Init
 * parameters (such as baud rate or own CAN address) entered during startup:
 * See DNS_FAL_GEN_STATUS_T.
*******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_GET_STATUS_REQ_Ttag {
  TLR_UINT16  usArea;                      /* Area: set to 0                  */
  TLR_UINT16  usSubArea;                   /* 0 = DNS_FAL_GEN_STATUS_T        */
                                           /* 1 = ulStatusFlags;              */
                                           /* 2 = ulRxInt;                    */
                                           /* 3 = ulTxInt;                    */
                                           /* 4 = ulRxOverRun;                */
                                           /* 5 = ulTxOverRun;                */
                                           /* 6 = ulTxAborts;                 */
                                           /* 7 = ulErrorInt;                 */
                                           /* 8 = ulBusOffCnt;                */
                                           /* 9 = ulResetCnt;                 */
                                           /* 10 =ulNodeId;                   */
                                           /* 11 =ulBaudrate;                 */
                                           /* 12 =usVendorId;                 */
                                           /* 13 =usProducedSize;             */
                                           /* 13 =usConsumedSize;             */
} DNS_FAL_GET_STATUS_REQ_T;

#define DNS_FAL_GET_STATUS_REQ_SIZE sizeof(DNS_FAL_GET_STATUS_REQ_T)
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_GET_STATUS_REQ_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_GET_STATUS_REQ_T tData;
} DNS_FAL_PACKET_GET_STATUS_REQ_T;

/******************************************************************************/
/*                     DNS_FAL_CMD_GET_STATUS_CNF Structure                   */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_GEN_STATUS_Ttag {
  TLR_UINT32 ulStatusFlags;                  /* Value of MSK_DNS_STA_FLAG_ .. */
  TLR_UINT32 ulRxInt;                        /* received CAN telegrams        */
  TLR_UINT32 ulTxInt;                        /* transmitted CAN telegrams     */
  TLR_UINT32 ulRxOverRun;                    /* detected receive overruns     */
  TLR_UINT32 ulTxOverRun;                    /* detected transmission overrun */
  TLR_UINT32 ulTxAborts;                     /* transmission abort events     */
  TLR_UINT32 ulErrorInt;            /* a counter for low transmission quality */
  TLR_UINT32 ulBusOffCnt;                    /* the counter for bus off events*/
  TLR_UINT32 ulResetCnt;                     /* reset counter                 */
  TLR_UINT32 ulNodeId;                       /* 0.. 63                        */
  TLR_UINT32 ulBaudrate;                     /* Values of DNS_FAL_BAUDRATE_ ..*/
  TLR_UINT16 usVendorId;                     /* ODVA Vendor ID                */
  TLR_UINT16 usProducedSize;                 /* 0..255                        */
  TLR_UINT16 usConsumedSize;                 /* 0..255                        */
  TLR_UINT16 usReserved;                     /* Zero filled                   */
} DNS_FAL_GEN_STATUS_T;

#define DNS_FAL_GET_STATUS_CNF_MAX_DATA (256)
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_GET_STATUS_CNF_Ttag {
  TLR_UINT16  usArea;                        /* Area the same as in request   */
  TLR_UINT16  usSubArea;                     /* SubArea the same as in request*/
  TLR_UINT8   abData[DNS_FAL_GET_STATUS_CNF_MAX_DATA];  /* Data see sub-areas */
} DNS_FAL_GET_STATUS_CNF_T;

#define DNS_FAL_GET_STATUS_CNF_SIZE (sizeof(DNS_FAL_GET_STATUS_CNF_T)- \
                                     DNS_FAL_GET_STATUS_CNF_MAX_DATA)
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_GET_STATUS_CNF_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_GET_STATUS_CNF_T tData;
} DNS_FAL_PACKET_GET_STATUS_CNF_T;

/*******************************************************************************
 *                       DNS_FAL_CMD_SET_MODE_REQ Structure
 *
 * This packet describes how to set a different mode of operation.
*******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_SET_MODE_REQ_Ttag {
  TLR_UINT32  ulMode;                            /* Value of DNS_FAL_MODE_ .. */
  TLR_UINT32  ulInfo;                            /* Number of Bus On Count    */
} DNS_FAL_SET_MODE_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_SET_MODE_REQ_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_SET_MODE_REQ_T tData;
} DNS_FAL_PACKET_SET_MODE_REQ_T;

/******************************************************************************/
/*                   DNS_FAL_CMD_SET_MODE_CNF Structure                       */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_SET_MODE_CNF_Ttag {
  TLR_UINT32 ulMode;                          /* Mode, the same as in request */
  TLR_UINT32 ulInfo;                          /* Info, the same as in request */
} DNS_FAL_SET_MODE_CNF_T;

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_SET_MODE_CNF_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_SET_MODE_CNF_T tData;
} DNS_FAL_PACKET_SET_MODE_CNF_T;

/*******************************************************************************
 *                   DNS_FAL_CMD_CLR_CONFIG_REQ Structure
 *
 *     This packet clears the configuration data stored in the device.
*******************************************************************************/
/* Set Mode req */
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_SDU_CLR_CONFIG_REQ_Ttag
{
  TLR_UINT32 ulCfgArea;                   /* 0 = Clear all configuration data */
}DNS_FAL_SDU_CLR_CONFIG_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_CLR_CONFIG_REQ_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_SDU_CLR_CONFIG_REQ_T tData;
} DNS_FAL_PACKET_CLR_CONFIG_REQ_T;

/******************************************************************************/
/*                    DNS_FAL_CMD_CLR_CONFIG_CNF Structure                    */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_CLR_CONFIG_CNF_Ttag {
  TLR_PACKET_HEADER_T tHead;
} DNS_FAL_PACKET_CLR_CONFIG_CNF_T;

/*******************************************************************************
 *                      DNS_FAL_CMD_UPDATE_IO_REQ Structure
 *
 * The command DNS_FAL_UPDATE_IO_REQ is used by user application to get the
 * output data as well as set the input data from the DNS-Task.
*******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_UPADTE_IO_REQ_Ttag {
  TLR_UINT32   ulOutOffSet;                      /* Offset in the Output Data */
  TLR_UINT32   ulOutLen;                         /* Length of outputs         */
  TLR_UINT32   ulOutDataSta;                     /* Reserved, set to zero     */
  TLR_UINT32   ulInOffSet;                  /* Offset in the Input Data image */
  TLR_UINT32   ulInLen;                          /* Input length.             */
  TLR_UINT32   ulInDataSta;                      /* Reserved, set to zero     */
  TLR_UINT8    abInData[DNS_FAL_MAX_IO_SIZE];    /* Output data from slave    */
} DNS_FAL_UPDATE_IO_REQ_T;

#define DNS_FAL_UPDATE_IO_REQ_SIZE (sizeof(DNS_FAL_UPDATE_IO_REQ_T)- \
                                    DNS_FAL_MAX_IO_SIZE)
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_UPDATE_IO_REQ_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_UPDATE_IO_REQ_T tData;
} DNS_FAL_PACKET_UPDATE_IO_REQ_T;

/******************************************************************************/
/*                      DNS_FAL_CMD_UPDATE_IO_CNF Structure                   */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_UPDATE_IO_CNF_Ttag {
  TLR_UINT32   ulOutOffSet;                      /* Offset in the Output Data */
  TLR_UINT32   ulOutLen;                         /* Length of outputs         */
  TLR_UINT32   ulOutDataSta;                     /* Value of DNS_FAL_DS_ ..   */
  TLR_UINT32   ulInOffSet;                  /* Offset in the Input Data image */
  TLR_UINT32   ulInLen;                          /* Input length.             */
  TLR_UINT32   ulInDataSta;                      /* Reserved, set to zero     */
   TLR_UINT8   abOutData[DNS_FAL_MAX_IO_SIZE];   /* Output data from slave    */
} DNS_FAL_UPDATE_IO_CNF_T;

#define DNS_FAL_UPDATE_IO_CNF_SIZE (sizeof(DNS_FAL_UPDATE_IO_CNF_T)- \
                                    DNS_FAL_MAX_IO_SIZE)
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_UPDATE_IO_CNF_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_UPDATE_IO_CNF_T tData;
} DNS_FAL_PACKET_UPDATE_IO_CNF_T;

/*******************************************************************************
 *                     DNS_FAL_CMD_SET_INPUT_REQ Structure
 *
 * The command DNS_FAL_CMD_SET_INPUT_REQ is used by the user application to
 * update user input data to the DNS-Task. The input information will appear
 * as input values to the DeviceNet Master
*******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_SET_INPUT_REQ_Ttag {
  TLR_UINT32   ulInOffSet;                        /* Offset of producing data */
  TLR_UINT32   ulInLen;                           /* Produced data length     */
  TLR_UINT32   ulInDataSta;                       /* Reserved set to 0        */
  TLR_UINT8    abInData[DNS_FAL_MAX_IO_SIZE];     /* Produced data load       */
} DNS_FAL_SET_INPUT_REQ_T;

#define DNS_FAL_SET_INPUT_REQ_SIZE (sizeof(DNS_FAL_SET_INPUT_REQ_T)- \
                                    DNS_FAL_MAX_IO_SIZE)
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_SET_INPUT_REQ_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_SET_INPUT_REQ_T tData;
} DNS_FAL_PACKET_SET_INPUT_REQ_T;

/******************************************************************************/
/*                      DNS_FAL_CMD_SET_INPUT_CNF Structure                   */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_SET_INPUT_CNF_Ttag {
  TLR_UINT32   ulInOffSet;                   /* Offset the same as in request */
  TLR_UINT32   ulInLen;                 /* Data length the same as in request */
  TLR_UINT32   ulInDataSta;               /* Data status the same as request  */
} DNS_FAL_SET_INPUT_CNF_T;

#define DNS_FAL_SET_INPUT_CNF_SIZE  sizeof(DNS_FAL_SET_INPUT_CNF_T)
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_SET_INPUT_CNF_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_SET_INPUT_CNF_T tData;
} DNS_FAL_PACKET_SET_INPUT_CNF_T;

/*******************************************************************************
 *                     DNS_FAL_CMD_GET_OUTPUT_REQ Structure
 * The command DNS_FAL_CMD_GET_OUTPUT_REQ is used to obtain the output data
 * from the DNS-Task. This packet provice other mean to get output from the
 * master except reading from input area in the DPM.
 ******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_GET_OUTPUT_REQ_Ttag {
  TLR_UINT32   ulOutOffSet;                                  /* Output offset */
  TLR_UINT32   ulOutLen;                                     /* Output length */
} DNS_FAL_GET_OUTPUT_REQ_T;

#define DNS_FAL_GET_OUTPUT_REQ_SIZE  sizeof(DNS_FAL_GET_OUTPUT_REQ_T)
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_GET_OUTPUT_REQ_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_GET_OUTPUT_REQ_T tData;
} DNS_FAL_PACKET_GET_OUTPUT_REQ_T;

/******************************************************************************/
/*                    DNS_FAL_CMD_GET_OUTPUT_CNF Structure                    */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_GET_OUTPUT_CNF_Ttag {
  TLR_UINT32  ulOutOffSet;                                   /* Output offset */
  TLR_UINT32  ulOutLen;                                      /* Output length */
  TLR_UINT32  ulOutDataSta;                            /* See DNS_FAL_DS_ ... */
  TLR_UINT8   abOutData[DNS_FAL_MAX_IO_SIZE];                /* Output data   */
} DNS_FAL_GET_OUTPUT_CNF_T;

#define DNS_FAL_GET_OUTPUT_CNF_SIZE (sizeof(DNS_FAL_GET_OUTPUT_CNF_T)- \
                                     DNS_FAL_MAX_IO_SIZE)
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_GET_OUTPUT_CNF_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_GET_OUTPUT_CNF_T tData;
} DNS_FAL_PACKET_GET_OUTPUT_CNF_T;

/*******************************************************************************
 *                       DNS_FAL_CMD_GET_SET_ATT_IND/INDRET
 * The Get/Set Attribute Indication command signals the user application that
 * a Get/Set attribute request was sent by a DeviceNet Master. The user is
 * expected to provide a response to this command to acknowledge its receipt
 * including return data. Otherwise, the user is endangered to be excluded
 * from communication on the DeviceNet as usually Get- and Set Attribute
 * commands are supervised by the master via a timer. User gets the GetSet
 * Indication only for get_attribute_single and set_attribute_single
*******************************************************************************/
#define DNS_FAL_GET_SET_ATT_MAX_DATA  240

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_GET_SET_ATT_IND_Ttag {
  TLR_UINT16  usClassId;                               /* COMMON CIP CLASS ID */
  TLR_UINT16  usInstId;                         /* Instance Id of the object  */
  TLR_UINT16  usAttId;                         /* Attribute ID within instance */
  TLR_UINT16  usDataCnt;                        /* Data load length of abData */
  TLR_UINT8   bFunction;                        /* DNS_FAL_GET_SET_ATT_ ..    */
  TLR_UINT8   abReserved[3];
  TLR_UINT8   abData[DNS_FAL_GET_SET_ATT_MAX_DATA];    /* Data Load           */
} DNS_FAL_GET_SET_ATT_IND_T;

#define DNS_FAL_GETSET_ATT_IND_SIZE (sizeof(DNS_FAL_GET_SET_ATT_IND_T)- \
                                     DNS_FAL_GET_SET_ATT_MAX_DATA)
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_GET_SET_ATT_IND_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_GET_SET_ATT_IND_T tData;
} DNS_FAL_PACKET_GET_SET_ATT_IND_T;

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_GET_SET_ATT_INDRET_Ttag {
  TLR_PACKET_HEADER_T tHead;
} DNS_FAL_PACKET_GET_SET_ATT_INDRET_T;


/******************************************************************************/
/*                         DNS_FAL_CMD_GET_SET_ATT_RES                        */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_GET_SET_ATT_RES_Ttag {
  TLR_UINT16  usClassId;                               /* COMMON CIP CLASS ID */
  TLR_UINT16  usInstId;                         /* Instance Id of the object  */
  TLR_UINT16  usAttId;                        /* Attribute ID within instance */
  TLR_UINT16  usDataCnt;              /* Data load length of abData           */
  TLR_UINT8   bFunction;              /* DNS_FAL_GET_SET_ATT_ ..              */
  TLR_UINT8   bGenErrCode;            /* General Error Code DNS_CIP_GEN_E_ .. */
  TLR_UINT8   bAddErrCode;            /* Additional Error Code                */
  TLR_UINT8   bReserved;
  TLR_UINT8   abData[DNS_FAL_GET_SET_ATT_MAX_DATA];
} DNS_FAL_GET_SET_ATT_RES_T;

#define DNS_FAL_GETSET_ATT_RES_SIZE (sizeof(DNS_FAL_GET_SET_ATT_RES_T)- \
                                     DNS_FAL_GET_SET_ATT_MAX_DATA)
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_GET_SET_ATT_RES_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_GET_SET_ATT_RES_T tData;
} DNS_FAL_PACKET_GET_SET_ATT_RES_T;


/******************************************************************************/
/*                         DNS_FAL_CMD_GET_SET_ATT_RESRET                     */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_GET_SET_ATT_RESRET_Ttag {
  TLR_UINT16  usClassId;                               /* COMMON CIP CLASS ID */
  TLR_UINT16  usInstId;                         /* Instance Id of the object  */
  TLR_UINT16  usAttId;                        /* Attribute ID within instance */
  TLR_UINT16  usDataCnt;              /* Data load length of abData           */
  TLR_UINT8   bFunction;              /* DNS_FAL_GET_SET_ATT_ ..              */
  TLR_UINT8   bGenErrCode;            /* General Error Code DNS_CIP_GEN_E_ .. */
  TLR_UINT8   bAddErrCode;            /* Additional Error Code                */
  TLR_UINT8   bReserved;
} DNS_FAL_GET_SET_ATT_RESRET_T;

#define DNS_FAL_GETSET_ATT_RESRET_SIZE (sizeof(DNS_FAL_GET_SET_ATT_RESRET_T))
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_GET_SET_ATT_RESRET_Ttag
{
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_GET_SET_ATT_RESRET_T tData;
} DNS_FAL_PACKET_GET_SET_ATT_RESRET_T;


/* This definition is used in both DNS_FAL_CMD_REMOTE_SERVICE_IND/RES         */
#define DNS_FAL_REMOTE_SERVICE_MAX_DATA  248
                             /* Length of ptRsc->tLoc.tVars.explicit_msg_data */

/******************************************************************************/
/*                      DNS_FAL_CMD_REMOTE_SERVICE_IND                        */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_REMOTE_SERVICE_IND_Ttag{
  /* Volume 1 Common Industrial Protocol Specification Chapter 5, Table 5-1.1 */
  TLR_UINT16  usClassId;                               /* Class Id            */

  TLR_UINT16  usInstanceId;    /* Instance Id. See specs of individual object */

  TLR_UINT16  usReserved;      /* Paddling for Attribute Id.                  */

  TLR_UINT16  usSrvDatLen;     /* Effective Length of Data in abSrvData       */

  /*
  00=Reserved 01=Get_Attributes_All  02=Set_Attributes_All 03=Get_Attribute_List
  04=Set_Attribute_List 05=Reset 06=Start 07=Stop 08=Create 09=Delete
  0A=Multiple_Service_Packet 0B=Reserved for future use 0D=Apply_Attributes
  0E=Get_Attribute_Single 0F=Reserved for future use 10=Set_Attribute_Single
  11=Find_Next_Object_Instance 12-13=Reserved for future use
  14=ror Response (used by DevNet only) 15=Restore 16=Save 17=No Operation(NOP)
  18=Get_Member 19=Set_Member 1A=Insert_Member 1B=Remove_Member 1C=GroupSync
  1D-31 = Reserved for additional Common Services*/
  TLR_UINT8   bServiceCode;                              /* Service Code      */

  TLR_UINT8   abReserved[3]; /*Reserved. Paddling for bGenErrCode, bAddErrCode*/
    
  TLR_UINT8   abSrvData[DNS_FAL_REMOTE_SERVICE_MAX_DATA];/* Service data      */
}DNS_FAL_REMOTE_SERVICE_IND_T;

#define DNS_FAL_REMOTE_SERVICE_IND_SIZE (sizeof(DNS_FAL_REMOTE_SERVICE_IND_T) \
                                         -DNS_FAL_REMOTE_SERVICE_MAX_DATA)

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_REMOTE_SERVICE_IND_Ttag
{
  TLR_PACKET_HEADER_T          tHead;
  DNS_FAL_REMOTE_SERVICE_IND_T tData;
}DNS_FAL_PACKET_REMOTE_SERVICE_IND_T;


/******************************************************************************/
/*                      DNS_FAL_CMD_REMOTE_SERVICE_RES                        */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_REMOTE_SERVICE_RES_Ttag{
  /* Volume 1 Common Industrial Protocol Specification Chapter 5, Table 5-1.1 */
  TLR_UINT16  usClassId;                               /* Class Id            */

  TLR_UINT16  usInstanceId;    /* Instance Id. See specs of individual object */

  TLR_UINT16  usReserved;      /* Paddling for Attribute Id.                  */

  TLR_UINT16  usSrvDatLen;     /* Effective Length of Data in abSrvData       */

  /*
  00=Reserved 01=Get_Attributes_All  02=Set_Attributes_All 03=Get_Attribute_List
  04=Set_Attribute_List 05=Reset 06=Start 07=Stop 08=Create 09=Delete
  0A=Multiple_Service_Packet 0B=Reserved for future use 0D=Apply_Attributes
  0E=Get_Attribute_Single 0F=Reserved for future use 10=Set_Attribute_Single
  11=Find_Next_Object_Instance 12-13=Reserved for future use
  14=ror Response (used by DevNet only) 15=Restore 16=Save 17=No Operation(NOP)
  18=Get_Member 19=Set_Member 1A=Insert_Member 1B=Remove_Member 1C=GroupSync
  1D-31 = Reserved for additional Common Services*/
  TLR_UINT8   bServiceCode;     /* Service Code. 14 in case of error response */

  TLR_UINT8   bGenErrCode;      /* General error code. Appendix B-1. Volume 1 */

  TLR_UINT8   bAddErrCode;      /* Additional error code. Exp Msg. Volume 3   */

  TLR_UINT8   bReserved;         /* Padding byte  */

  TLR_UINT8   abSrvData[DNS_FAL_REMOTE_SERVICE_MAX_DATA];/* Service data      */
}DNS_FAL_REMOTE_SERVICE_RES_T;

#define DNS_FAL_REMOTE_SERVICE_RES_SIZE (sizeof(DNS_FAL_REMOTE_SERVICE_RES_T) \
                                         -DNS_FAL_REMOTE_SERVICE_MAX_DATA)

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_REMOTE_SERVICE_RES_Ttag
{
  TLR_PACKET_HEADER_T          tHead;
  DNS_FAL_REMOTE_SERVICE_RES_T tData;
}DNS_FAL_PACKET_REMOTE_SERVICE_RES_T;

 
/******************************************************************************/
/*                      DNS_FAL_CMD_SERVICE_REQ                               */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_SERVICE_IND_Ttag{
  /* Volume 1 Common Industrial Protocol Specification Chapter 5, Table 5-1.1 */
  TLR_UINT16  usClassId;                               /* Class Id            */

  TLR_UINT16  usInstanceId;    /* Instance Id. See specs of individual object */

  TLR_UINT16  usAttribute;      /* Attribute Id for get/set attr only         */

  TLR_UINT16  usSrvDatLen;     /* Effective Length of Data in abSrvData       */

  /*
  00=Reserved 01=Get_Attributes_All  02=Set_Attributes_All 03=Get_Attribute_List
  04=Set_Attribute_List 05=Reset 06=Start 07=Stop 08=Create 09=Delete
  0A=Multiple_Service_Packet 0B=Reserved for future use 0D=Apply_Attributes
  0E=Get_Attribute_Single 0F=Reserved for future use 10=Set_Attribute_Single
  11=Find_Next_Object_Instance 12-13=Reserved for future use
  14=ror Response (used by DevNet only) 15=Restore 16=Save 17=No Operation(NOP)
  18=Get_Member 19=Set_Member 1A=Insert_Member 1B=Remove_Member 1C=GroupSync
  1D-31 = Reserved for additional Common Services*/
  TLR_UINT8   bServiceCode;                              /* Service Code      */

  TLR_UINT8   abReserved[2]; /*Reserved. Paddling for bGenErrCode, bAddErrCode*/
  
  TLR_UINT8   bDevMacId;                      /* reserved, not used, set to 0 */

  TLR_UINT8   abSrvData[DNS_FAL_REMOTE_SERVICE_MAX_DATA];     /* Service data */
}DNS_FAL_SERVICE_REQ_T;

#define DNS_FAL_SERVICE_REQ_SIZE (sizeof(DNS_FAL_SERVICE_REQ_T) \
                                         -DNS_FAL_REMOTE_SERVICE_MAX_DATA)

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_SERVICE_REQ_Ttag
{
  TLR_PACKET_HEADER_T        tHead;
  DNS_FAL_SERVICE_REQ_T      tData;
}DNS_FAL_PACKET_SERVICE_REQ_T;


/******************************************************************************/
/*                      DNS_FAL_CMD_SERVICE_CNF                               */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_SERVICE_CNF_Ttag{
  /* Volume 1 Common Industrial Protocol Specification Chapter 5, Table 5-1.1 */
  TLR_UINT16  usClassId;                               /* Class Id            */

  TLR_UINT16  usInstanceId;    /* Instance Id. See specs of individual object */

  TLR_UINT16  usAttribute;     /* Attribute Id for get/set attr only          */

  TLR_UINT16  usSrvDatLen;     /* Effective Length of Data in abSrvData       */

  /*
  00=Reserved 01=Get_Attributes_All  02=Set_Attributes_All 03=Get_Attribute_List
  04=Set_Attribute_List 05=Reset 06=Start 07=Stop 08=Create 09=Delete
  0A=Multiple_Service_Packet 0B=Reserved for future use 0D=Apply_Attributes
  0E=Get_Attribute_Single 0F=Reserved for future use 10=Set_Attribute_Single
  11=Find_Next_Object_Instance 12-13=Reserved for future use
  14=ror Response (used by DevNet only) 15=Restore 16=Save 17=No Operation(NOP)
  18=Get_Member 19=Set_Member 1A=Insert_Member 1B=Remove_Member 1C=GroupSync
  1D-31 = Reserved for additional Common Services*/
  TLR_UINT8   bServiceCode;     /* Service Code. 14 in case of error response */

  TLR_UINT8   bGenErrCode;      /* General error code. Appendix B-1. Volume 1 */

  TLR_UINT8   bAddErrCode;      /* Additional error code. Exp Msg. Volume 3   */

  TLR_UINT8   bDevMacId;        /*  reserved, not used, set to 0              */

  TLR_UINT8   abSrvData[DNS_FAL_REMOTE_SERVICE_MAX_DATA];/* Service data      */
}DNS_FAL_SERVICE_CNF_T;

#define DNS_FAL_SERVICE_CNF_SIZE (sizeof(DNS_FAL_SERVICE_CNF_T) \
                                           -DNS_FAL_REMOTE_SERVICE_MAX_DATA)

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_SERVICE_CNF_Ttag
{
  TLR_PACKET_HEADER_T          tHead;
  DNS_FAL_SERVICE_CNF_T        tData;
}DNS_FAL_PACKET_SERVICE_CNF_T;


/******************************************************************************/
/*                    DNS_FAL_CMD_UPDATE_IO_IND Structure                     */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_UPDATE_IO_IND_Ttag {
  TLR_PACKET_HEADER_T tHead;
} DNS_FAL_PACKET_UPDATE_IO_IND_T;

/******************************************************************************/
/*                     DNS_FAL_CMD_UPDATE_IO_RES Structure                    */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_UPDATE_IO_RES_Ttag {
  TLR_PACKET_HEADER_T tHead;
} DNS_FAL_PACKET_UPDATE_IO_RES_T;


/******************************************************************************/
/*                     DNS_FAL_CMD_LED_STATE_IND Structure                    */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_LED_STATE_Ttag
{
  TLR_UINT32 ulLedType;  /* MNS = 1, NS = 2, MS = 3  DNS_FAL_LED_TYPE_..      */
  TLR_UINT32 ulLedMode;  /* STATIC = 1, FLASH = 2, DNS_FAL_LED_MODE_..        */
  TLR_UINT32 ulLedColor; /* RED = 3, GRN = 2, OFF= 1, DNS_FAL_LED_COLOR_ ..   */
} DNS_FAL_LED_STATE_T;

#define DNS_FAL_LED_STATE_IND_SIZE (sizeof(DNS_FAL_LED_STATE_T))

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_LED_STATE_IND_Ttag {
  TLR_PACKET_HEADER_T tHead;
  DNS_FAL_LED_STATE_T tData;
} DNS_FAL_PACKET_LED_STATE_IND_T;

/******************************************************************************/
/*                       DNS_FAL_CMD_LED_STATE_RES Structure                  */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_LED_STATE_RES_Ttag {
  TLR_PACKET_HEADER_T tHead;
} DNS_FAL_PACKET_LED_STATE_RES_T;


/******************************************************************************/
/*                     DNS_FAL_CMD_REGISTER_CLASS_REQ Structure               */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_REGISTER_CLASS_Ttag
{
    TLR_UINT32 ulClass;           /* Class identifier. See DNS_CIP_CLASS_ ... */
    TLR_UINT32 ulAccessTyp;               /* Instance, Class access. Set to 0 */
} DNS_FAL_REGISTER_CLASS_T;

#define DNS_FAL_REGISTER_CLASS_REQ_SIZE (sizeof(DNS_FAL_REGISTER_CLASS_T))

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_REGISTER_CLASS_REQ_Ttag
{
  TLR_PACKET_HEADER_T      tHead;
  DNS_FAL_REGISTER_CLASS_T tData;

} DNS_FAL_PACKET_REGISTER_CLASS_REQ_T;

/******************************************************************************/
/*                  DNS_FAL_CMD_REGISTER_CLASS_RES Structure                  */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_REGISTER_CLASS_CNF_Ttag
{
  TLR_PACKET_HEADER_T      tHead;
  DNS_FAL_REGISTER_CLASS_T tData;

} DNS_FAL_PACKET_REGISTER_CLASS_CNF_T;

/******************************************************************************/
/*                  DNS_FAL_CMD_UNREGISTER_CLASS_REQ Structure                */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_UNREGISTER_CLASS_Ttag
{
    TLR_UINT32 ulClass;          /* Class identifier: DNS_CIP_CLASS_ ..       */
    TLR_UINT32 ulAccessTyp;      /* Instance, Class access. Reserved          */
} DNS_FAL_UNREGISTER_CLASS_T;

#define DNS_FAL_UNREGISTER_CLASS_REQ_SIZE (sizeof(DNS_FAL_UNREGISTER_CLASS_T))

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_UNREGISTER_CLASS_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  DNS_FAL_UNREGISTER_CLASS_T      tData;
} DNS_FAL_PACKET_UNREGISTER_CLASS_REQ_T;

/******************************************************************************/
/*                 DNS_FAL_CMD_UNREGISTER_CLASS_RES Structure                 */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_UNREGISTER_CLASS_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  DNS_FAL_UNREGISTER_CLASS_T      tData;
} DNS_FAL_PACKET_UNREGISTER_CLASS_CNF_T;

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__DNS_FAL_PUBLIC)
#endif


/******************************************************************************/
/*                  DNS_FAL_CMD_ADR_SW_ENABLED_IND Structure                  */
/******************************************************************************/
#define DNS_FAL_SW_TYPE_ADR           (1)

#define DNS_FAL_SW_TYPE_BAUD          (2)

#define DNS_FAL_SW_ENABLE_STANDARD    (1)

#define DNS_FAL_SW_ENABLE_FW_PRM_SET  (2)

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_ADR_SW_ENABLE_Ttag
{
  TLR_UINT32 ulSwType;                                 /* DNS_FAL_SW_TYPE_ .. */

  TLR_UINT32 ulEnable;                                         /* 1 = Enabled */
}
DNS_FAL_ADR_SW_ENABLE_T;

#define DNS_FAL_ADR_SW_ENABLE_IND_SIZE (sizeof(DNS_FAL_ADR_SW_ENABLE_T))

typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_SW_ENABLE_IND_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  DNS_FAL_ADR_SW_ENABLE_T         tData;
}
DNS_FAL_PACKET_SW_ENABLE_IND_T;

/******************************************************************************/
/*                  DNS_FAL_CMD_ADR_SW_ENABLED_RES Structure                  */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNS_FAL_PACKET_ADR_SW_ENABLE_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;

  DNS_FAL_ADR_SW_ENABLE_T         tData;
}
DNS_FAL_PACKET_ADR_SW_ENABLE_RES_T;

#define DNS_FAL_ADR_SW_ENABLE_RES_SIZE (sizeof(DNS_FAL_ADR_SW_ENABLE_T))

/******************************************************************************/
#endif /* #ifndef __DNS_FAL_PUBLIC_H */
